/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.mana;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.Shearable;
import net.minecraft.world.entity.animal.Cow;
import net.minecraft.world.entity.animal.MushroomCow;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import vazkii.botania.api.internal.IManaBurst;
import vazkii.botania.api.mana.IManaTrigger;
import vazkii.botania.common.block.BlockModWaterloggable;
import vazkii.botania.common.block.subtile.functional.SubTileBergamute;
import vazkii.botania.common.handler.ModSounds;
import vazkii.botania.common.item.ItemHorn;
import vazkii.botania.common.item.ModItems;

public class BlockForestDrum
extends BlockModWaterloggable {
    private static final VoxelShape SHAPE = Block.m_49796_((double)3.0, (double)1.0, (double)3.0, (double)13.0, (double)15.0, (double)13.0);
    private final Variant variant;

    public BlockForestDrum(Variant v, BlockBehaviour.Properties builder) {
        super(builder);
        this.variant = v;
    }

    @Nonnull
    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext ctx) {
        return SHAPE;
    }

    private static void convertNearby(Entity entity, Item from, Item to) {
        Level world = entity.f_19853_;
        List items = world.m_45976_(ItemEntity.class, entity.m_142469_());
        for (ItemEntity item : items) {
            ItemStack itemstack = item.m_32055_();
            if (itemstack.m_41619_() || !itemstack.m_150930_(from) || world.f_46443_) continue;
            while (itemstack.m_41613_() > 0) {
                ItemEntity ent = entity.m_5552_(new ItemStack((ItemLike)to), 1.0f);
                ent.m_20256_(ent.m_20184_().m_82520_((double)(world.f_46441_.nextFloat() * 0.05f), (double)((world.f_46441_.nextFloat() - world.f_46441_.nextFloat()) * 0.1f), (double)((world.f_46441_.nextFloat() - world.f_46441_.nextFloat()) * 0.1f)));
                itemstack.m_41774_(1);
            }
            item.m_146870_();
        }
    }

    public static enum Variant {
        WILD,
        GATHERING,
        CANOPY;

    }

    public static class ManaTrigger
    implements IManaTrigger {
        private final Level world;
        private final BlockPos pos;
        private final Variant variant;

        public ManaTrigger(Level world, BlockPos pos, BlockState state) {
            this.world = world;
            this.pos = pos;
            this.variant = ((BlockForestDrum)state.m_60734_()).variant;
        }

        @Override
        public void onBurstCollision(IManaBurst burst) {
            if (burst.isFake()) {
                return;
            }
            if (this.world.f_46443_) {
                this.world.m_7106_((ParticleOptions)ParticleTypes.f_123758_, (double)this.pos.m_123341_() + 0.5, (double)this.pos.m_123342_() + 1.2, (double)this.pos.m_123343_() + 0.5, 0.041666666666666664, 0.0, 0.0);
                return;
            }
            if (this.variant == Variant.WILD) {
                ItemHorn.breakGrass(this.world, new ItemStack((ItemLike)ModItems.grassHorn), this.pos, null);
            } else if (this.variant == Variant.CANOPY) {
                ItemHorn.breakGrass(this.world, new ItemStack((ItemLike)ModItems.leavesHorn), this.pos, null);
            } else {
                int range = 10;
                List entities = this.world.m_6443_(Mob.class, new AABB(this.pos.m_142082_(-range, -range, -range), this.pos.m_142082_(range + 1, range + 1, range + 1)), e -> !SubTileBergamute.isBergamuteNearby(this.world, e.m_20185_(), e.m_20186_(), e.m_20189_()));
                ArrayList<Mob> shearables = new ArrayList<Mob>();
                for (Mob entity : entities) {
                    Shearable shearable;
                    if (entity instanceof Cow) {
                        BlockForestDrum.convertNearby((Entity)entity, Items.f_42446_, Items.f_42455_);
                        if (!(entity instanceof MushroomCow)) continue;
                        BlockForestDrum.convertNearby((Entity)entity, Items.f_42399_, Items.f_42400_);
                        continue;
                    }
                    if (!(entity instanceof Shearable) || !(shearable = (Shearable)entity).m_6220_()) continue;
                    shearables.add(entity);
                }
                Collections.shuffle(shearables);
                int sheared = 0;
                for (Mob entity : shearables) {
                    if (sheared > 4) break;
                    if (entity instanceof Shearable) {
                        Shearable shearable = (Shearable)entity;
                        shearable.m_5851_(SoundSource.BLOCKS);
                    }
                    ++sheared;
                }
            }
            for (int i = 0; i < 10; ++i) {
                this.world.m_5594_(null, this.pos, ModSounds.drum, SoundSource.BLOCKS, 1.0f, 1.0f);
            }
        }
    }
}

